package cn.com.duiba.cloud.duiba.payment.service.api.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 退款通知参数
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/12/6 4:45 下午
 **/
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class MqRefundPayNotifyModel implements Serializable {
    private static final long serialVersionUID = -6989663737979196480L;
    /**
     * 业务单号
     */
    private String bizNo;

    /**
     * 业务版本好
     */
    private Integer bizVersion;

    /**
     * 支付方式
     */
    private Integer payMethod;

    /**
     * 支付金额（分）
     */
    private Long refundAmount;
}
