package cn.com.duiba.cloud.duiba.payment.service.api.param;

import cn.com.duiba.cloud.duiba.payment.service.api.enums.PayBindTypeEnum;
import cn.com.duiba.cloud.duiba.payment.service.api.model.PayUserBase;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.NonNull;
import lombok.RequiredArgsConstructor;

/**
 * 绑定账号请求
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/12/9 10:46 上午
 **/
@EqualsAndHashCode(callSuper = true)
@Data
@NoArgsConstructor
@RequiredArgsConstructor
public class BindAccountParam extends PayUserBase {
    private static final long serialVersionUID = 4533931912661039800L;

    /**
     * 绑定类型
     * 目前仅支持 ALIPAY
     *
     * @see PayBindTypeEnum
     */
    @NonNull
    private Integer bindType;

    /**
     * 账户名（支付宝/微信/银行卡id）
     */
    @NonNull
    private String account;

    /**
     * 真实姓名
     */
    @NonNull
    private String realName;
}
