package cn.com.duiba.cloud.duiba.payment.service.api.param;

import cn.com.duiba.cloud.duiba.payment.service.api.enums.PayBindTypeEnum;
import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 绑定账户查询
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/12/9 10:46 上午
 **/
@Data
@EqualsAndHashCode(callSuper = true)
public class BindAccountQueryParam extends PageRequest {
    private static final long serialVersionUID = -3403565527763185477L;

    /**
     * 用户类型
     */
    private Integer userType;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 账号
     */
    private String account;

    /**
     * 绑定类型
     *
     * @see PayBindTypeEnum
     */
    private Integer bindType;

    private Boolean isDelete;
}
