package cn.com.duiba.cloud.duiba.payment.service.api.param.app;

import cn.com.duiba.cloud.duiba.payment.service.api.enums.PayAccountTypeEnum;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * 应用人工充值
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/5/12 1:41 下午
 **/
@Data
public class AppAccountManualRechargeParam implements Serializable {
    private static final long serialVersionUID = 6587996432336025027L;

    /**
     * 应用Id
     */
    private Long appId;

    /**
     * 充值金额
     */
    private Long amount;


    /**
     * 主体类型（从management查）
     */
    private Integer businessEntityType;

    /**
     * 账户类型
     *
     * @see PayAccountTypeEnum
     */
    private Integer accountType;

    /**
     * 支付方式（充值方式）
     *
     * @see cn.com.duiba.cloud.duiba.payment.service.api.enums.PayMethodEnum
     */
    private Integer payMethod;


    /**
     * 业务编号（渠道流水号）
     */
    private String bizNo;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 备注
     */
    private String memo;

}
