package cn.com.duiba.cloud.duiba.payment.service.api.param.unifiedorder;

import cn.com.duiba.cloud.duiba.payment.service.api.model.PayUserBase;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.NonNull;
import lombok.RequiredArgsConstructor;

/**
 * 冻结单
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/18 11:46 上午
 **/
@EqualsAndHashCode(callSuper = true)
@Data
@NoArgsConstructor
@RequiredArgsConstructor
public class FrozenOrderParam extends PayUserBase {
    private static final long serialVersionUID = -2839472864075837518L;

    @NonNull
    private Integer accountType;

    /**
     * 冻结编号（冻结和解冻单号可以相同，可用于建立关联关系）
     */
    @NonNull
    private String frozenNo;

    /**
     * 冻结金额
     * refundAmount
     */
    @NonNull
    private Long frozenAmount;

    /**
     * 冻结原因，会在用户账单中看到，请严格处理
     */
    @NonNull
    private String frozenReason;
}
