package cn.com.duiba.cloud.duiba.payment.service.api.param.unifiedorder;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 退款统一下单
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/18 11:46 上午
 **/
@Data
public class RefundOrderParam implements Serializable {
    private static final long serialVersionUID = -2839472864075837518L;
    /**
     * 退款编号
     */
    @NotNull
    private String refundNo;

    /**
     * 退款金额
     * refundAmount
     */
    @NotNull
    private Long refundAmount;

    /**
     * 支付的业务单号
     */
    @NotNull
    private String payBizNo;

    /**
     * 支付的业务版本
     */
    @NotNull
    private Integer payBizVersion;


    /**
     * 退款原因，会在用户账单中看到，请严格处理
     */
    @NotNull
    private String refundReason;

    /**
     * 主体
     */
    private Integer businessEntityType;
}
