package cn.com.duiba.cloud.duiba.payment.service.api.param.unifiedorder;

import cn.com.duiba.cloud.duiba.payment.service.api.enums.PayAccountTypeEnum;
import cn.com.duiba.cloud.duiba.payment.service.api.model.PayUserBase;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.NonNull;

/**
 * 解冻单
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/18 11:46 上午
 **/
@Data
@EqualsAndHashCode(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
public class ThawOrderParam extends PayUserBase {
    private static final long serialVersionUID = -2839472864075837518L;

    /**
     * 账户类型
     *
     * @see PayAccountTypeEnum
     */
    @NonNull
    private Integer accountType;

    /**
     * 解冻编号（冻结和解冻单号可以相同，可用于上层建立关联关系）
     */
    @NonNull
    private String thawNo;

    /**
     * 冻结金额
     * refundAmount
     */
    @NonNull
    private Long thawAmount;

    /**
     * 冻结原因，会在用户账单中看到，请严格处理
     */
    @NonNull
    private String thawReason;
}
