package cn.com.duiba.cloud.duiba.payment.service.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.payment.service.api.dto.AccountTaxConfigDTO;
import cn.com.duiba.cloud.duiba.payment.service.api.param.AccountTaxConfigParam;

/**
 * 账户配置：税收
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/5/12 9:51 上午
 **/
@AdvancedFeignClient
public interface RemoteAccountConfigService {
    /**
     * 税收设置
     *
     * @param param
     */
    void setTaxConfig(AccountTaxConfigParam param);

    /**
     * 获取税收设置
     *
     * @param appId
     * @return
     */
    AccountTaxConfigDTO getTaxConfig(Long appId);

}
