package cn.com.duiba.cloud.duiba.payment.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.payment.service.api.dto.AccountDuibaRemindDTO;
import cn.com.duiba.cloud.duiba.payment.service.api.dto.AccountRemindDTO;
import cn.com.duiba.cloud.duiba.payment.service.api.param.payconfig.AccountRemindQueryParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * 资产预警
 * @author sunyan
 */
@AdvancedFeignClient
public interface RemoteAccountRemindService {
    /**
     * 查询开发者资产预警配置
     * @param appId
     * @return
     */
    AccountRemindDTO findRemind(Long appId);
    /**
     * 创建/更新开发者资产预警
     * @param accountRemindDTO
     * @throws BizException
     */
    void addOrUpdateRemind(AccountRemindDTO accountRemindDTO) throws BizException;
    /**
     * 查询兑吧管理应用资产预警
     * @param appId
     * @return
     */
    AccountDuibaRemindDTO findDuibaRemind(Long appId);
    /**
     * 新建/更新兑吧管理应用资产预警
     * @param accountDuibaRemindDTO
     * @return
     */
    void addOrUpdateDuibaRemind(AccountDuibaRemindDTO accountDuibaRemindDTO) throws BizException;
    /**
     * 分页查询开发者资金预警
     *
     * @param request
     * @return
     */
    PageResponse<AccountRemindDTO> getAccountRemindForPage(AccountRemindQueryParam request);
    /**
     * 分页查询兑吧资金预警
     *
     * @param request
     * @return
     */
    PageResponse<AccountDuibaRemindDTO> getAccountDuibaRemindForPage(AccountRemindQueryParam request);
}
