package cn.com.duiba.cloud.duiba.payment.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.payment.service.api.dto.BudgetConfigDTO;
import cn.com.duiba.cloud.duiba.payment.service.api.dto.BudgetInfoDTO;
import cn.com.duiba.cloud.duiba.payment.service.api.param.budget.BudgetCheckParam;
import cn.com.duiba.cloud.duiba.payment.service.api.param.budget.BudgetOptParam;
import cn.com.duiba.cloud.duiba.payment.service.api.param.budget.BudgetQueryParam;
import cn.com.duiba.cloud.duiba.payment.service.api.param.budget.BudgetSettingParam;

/**
 * 预算服务
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/5/16 3:03 下午
 **/
@AdvancedFeignClient
public interface RemoteBudgetService {

    /**
     * 校验预算
     *
     * @param param
     * @return true-通过 false-失败
     */
    Boolean checkBudget(BudgetCheckParam param);

    /**
     * 获取剩余预算信息
     *
     * @param param
     * @return
     */
    BudgetInfoDTO getBudgetInfo(BudgetQueryParam param);

    /**
     * 使用预算
     *
     * @param param
     */
    void useBudget(BudgetOptParam param) throws BizException;

    /**
     * 回退预算
     */
    void backBudget(BudgetOptParam param) throws BizException;

    /**
     * 设置预算配置
     *
     * @param param
     */
    void setBudgetConfig(BudgetSettingParam param);

    /**
     * 预算配置查询
     *
     * @param param
     * @return
     */
    BudgetConfigDTO queryBudgetConfig(BudgetQueryParam param);
}
