package cn.com.duiba.cloud.duiba.payment.service.api.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * 资金操作
 * <p>
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/16 3:18 下午
 **/
public class MoneyUtils {
    /**
     * 加
     *
     * @param a
     * @param b
     * @return
     */
    public static long add(long a, long b) {
        return BigDecimal.valueOf(a).add(BigDecimal.valueOf(b)).longValue();
    }

    /**
     * 减
     *
     * @param a
     * @param b
     * @return
     */
    public static long subtract(long a, long b) {
        return BigDecimal.valueOf(a).subtract(BigDecimal.valueOf(b)).longValue();
    }

    /**
     * 乘
     *
     * @param a
     * @param b
     * @return
     */
    public static long multiply(long a, long b) {
        return BigDecimal.valueOf(a).multiply(BigDecimal.valueOf(b)).longValue();
    }

    public static long multiplyDouble(Double a, Double b) {
        return new BigDecimal(a.toString()).multiply(new BigDecimal(b.toString())).setScale(0,RoundingMode.DOWN).longValue();
    }

    /**
     * 除
     *
     * @param a
     * @param b
     * @return
     */
    public static double divide(long a, long b) {
        return  BigDecimal.valueOf(a).divide( BigDecimal.valueOf(b),2,RoundingMode.DOWN).doubleValue();
    }

    /**
     * 负数
     *
     * @param a
     * @return
     */
    public static long minus(long a) {
        return -abs(a);
    }

    public static long abs(long a) {
        return Math.abs(a);
    }

    /**
     * 分转元
     *
     * @param fenMoney
     * @return
     */
    public static BigDecimal fen2yuan(Long fenMoney) {
        if (null == fenMoney) {
            return BigDecimal.ZERO.setScale(2);
        }
        return BigDecimal.valueOf(fenMoney).divide(BigDecimal.valueOf(100), 2, RoundingMode.DOWN);
    }

    /**
     * 元转分
     *
     * @param yuanMoney
     * @return
     */
    public static Long yuan2fen(Double yuanMoney) {
        if (null == yuanMoney) {
            return 0L;
        }
        return new BigDecimal("" + yuanMoney).multiply(BigDecimal.valueOf(100)).longValue();
    }

    /**
     * 分转元str
     *
     * @param fenMoney
     * @return
     */
    public static String fen2yuanStr(Long fenMoney) {
        return fen2yuan(fenMoney).toPlainString();
    }

    /**
     * 元转分str
     *
     * @param yuanMoney
     * @return
     */
    public static String yuan2fenStr(Double yuanMoney) {
        return yuan2fen(yuanMoney).toString();
    }

}
