/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.payment.service.api.enums;

import java.util.Arrays;
import java.util.List;

public enum PayBizTypeEnum {
    ORDER_PAY(1, "\u8ba2\u5355\u4ea4\u6613"),
    REFUND(2, "\u4ea4\u6613\u9000\u6b3e"),
    RECHARGE_MANUAL(3, "\u4eba\u5de5\u5145\u503c"),
    RECHARGE_ONLINE(4, "\u5728\u7ebf\u5145\u503c"),
    RECHARGE_GIVE(5, "\u8d60\u9001\u5145\u503c"),
    RECHARGE_CREDIT(6, "\u6388\u4fe1\u63d0\u989d"),
    DEDUCTION_MANUAL(7, "\u4eba\u5de5\u6263\u6b3e"),
    OVERDUE_CREDIT(8, "\u4fe1\u7528\u8fc7\u671f"),
    TRANSFER(9, "\u8f6c\u8d26"),
    WITHDRAW(10, "\u63d0\u73b0"),
    FROZEN(11, "\u51bb\u7ed3"),
    THAW(12, "\u89e3\u51bb");

    private Integer value;
    private String desc;

    private PayBizTypeEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (PayBizTypeEnum item : PayBizTypeEnum.values()) {
            if (item.value != value) continue;
            return item.desc;
        }
        return "";
    }

    public static PayBizTypeEnum valueOf(Integer value) {
        for (PayBizTypeEnum param : PayBizTypeEnum.values()) {
            if (!param.getValue().equals(value)) continue;
            return param;
        }
        return null;
    }

    public byte getByteValue() {
        return this.value.byteValue();
    }

    public static List<Integer> getTransferCategory() {
        return Arrays.asList(PayBizTypeEnum.RECHARGE_MANUAL.value, PayBizTypeEnum.RECHARGE_MANUAL.value, PayBizTypeEnum.RECHARGE_ONLINE.value, PayBizTypeEnum.RECHARGE_GIVE.value, PayBizTypeEnum.RECHARGE_CREDIT.value, PayBizTypeEnum.DEDUCTION_MANUAL.value, PayBizTypeEnum.TRANSFER.value, PayBizTypeEnum.FROZEN.value, PayBizTypeEnum.THAW.value);
    }

    public Integer getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }
}

