/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.payment.service.api.enums;

import java.util.Arrays;
import java.util.List;

public enum PayMethodEnum {
    MOCK(-1, "\u6a21\u62df"),
    WXPAY(1, "\u5fae\u4fe1"),
    ALIPAY(2, "\u652f\u4ed8\u5b9d"),
    BALANCE(3, "\u4f59\u989d"),
    SUBSIDY(4, "\u8865\u8d34"),
    LIANLIAN(5, "\u8fde\u8fde\u652f\u4ed8"),
    MANUAL_BANK(5, "\u4eba\u5de5-\u94f6\u884c"),
    MANUAL_ALIPAY(6, "\u4eba\u5de5-\u652f\u4ed8\u5b9d"),
    MANUAL_WXPAY(7, "\u4eba\u5de5-\u5fae\u4fe1"),
    MANUAL_OTHER(8, "\u4eba\u5de5-\u5176\u5b83");

    private Integer value;
    private String desc;

    private PayMethodEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (PayMethodEnum item : PayMethodEnum.values()) {
            if (item.value != value) continue;
            return item.desc;
        }
        return "";
    }

    public static List<PayMethodEnum> getDefaultPayMethod() {
        return Arrays.asList(ALIPAY, WXPAY);
    }

    public static PayMethodEnum valueOf(Integer value) {
        for (PayMethodEnum param : PayMethodEnum.values()) {
            if (!param.getValue().equals(value)) continue;
            return param;
        }
        return null;
    }

    public byte getByteValue() {
        return this.value.byteValue();
    }

    public Integer getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }
}

