package cn.com.duiba.cloud.risk.engine.api.constants.enums;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * 节点类型枚举
 *
 * @author zouwx
 * @date 2022/02/02
 */
@Getter
public enum NodeTypeEnum {

    /**
     * code
     */
    NODE(1, "节点"),
    CONDITION(2, "条件"),
    ;

    private Integer type;

    private String desc;

    NodeTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static final Map<Integer, NodeTypeEnum> ENUM_MAP = new HashMap<>();

    static {
        for (NodeTypeEnum tmp : values()) {
            ENUM_MAP.put(tmp.getType(), tmp);
        }
    }

    public static NodeTypeEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }
}
