package cn.com.duiba.cloud.risk.engine.api.dto.strategy;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * 策略
 *
 * @author zouwx
 * @date 2022/01/20
 */
@Data
public class RemoteStrategySaveDTO implements Serializable {

    private static final long serialVersionUID = 280599780605738087L;

    /**
     * id 新增不用传
     */
    private Long id;

    /**
     * 项目id
     */
    @NotNull(message = "项目id不能为空")
    private Long projectId;

    /**
     * 策略名称
     */
    @NotBlank(message = "策略名称不能为空")
    private String strategyName;


    /**
     * 策略描述
     */
    private String strategyDesc;

    /**
     * 场景列表
     */
    private List<Long> sceneList;

    /**
     * 规则id
     */
    @NotNull(message = "规则列表不能为空")
    @Size(min = 1,message = "规则列表最小一个")
    private List<Long> ruleIdList;

    /**
     * 低风险分
     */
    @NotNull(message = "低风险分不能为空")
    private Integer lowScore;

    /**
     * 高风险分
     */
    @NotNull(message = "高风险分不能为空")
    private Integer highScore;

}


