package cn.com.duiba.cloud.risk.engine.api.param.risk;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 规则引擎参数
 *
 * @author zouwx
 * @date 2022/02/15
 */
@Data
public class RiskEngineParam implements Serializable {

    private static final long serialVersionUID = 3284670712197560523L;

    /**
     * 消费者id
     */
    @NotNull(message = "用户id不能为空")
    private String consumerId;

    /**
     * 设备id
     */
    private String deviceId;

    /**
     * 场景id
     */
    @NotNull(message = "sceneId不能为空")
    private Long sceneId;

    /**
     * 项目id
     */
    @NotNull(message = "projectId不能为空")
    private Long projectId;

    /**
     * ip
     */
    @NotNull(message = "ip不能为空")
    private String ip;

    /**
     * ua
     */
    private String ua;

    /**
     * 手机号：选传，没有时为空即可
     */
    private String phone;

    /**
     * 地址，用于黑名单拦截
     */
    private String address;

}
