package cn.com.duiba.cloud.risk.engine.api.param.rule;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2022/1/26 11:07 上午
 **/
@Data
public class CreateRuleParam implements Serializable {

    private static final long serialVersionUID = 2374031084968994390L;

    /**
     * 项目id
     */
    private Long projectId;

    /**
     * 规则名称
     */
    private String ruleName;

    /**
     * 规则描述
     */
    private String ruleDesc;

    /**
     * 规则风险分
     */
    private Integer riskScore;

    /**
     * 是否需要满足所有条件
     * @see cn.com.duiba.cloud.risk.engine.api.constants.enums.RuleConditionEnum
     */
    private Integer ruleCondition;

    /**
     * 条件参数
     */
    private List<CreateRuleConditionParam> createRuleConditionParamLis;
}