package cn.com.duiba.cloud.risk.engine.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.risk.engine.api.dto.rule.PageRuleDTO;
import cn.com.duiba.cloud.risk.engine.api.dto.rule.RuleDetailDTO;
import cn.com.duiba.cloud.risk.engine.api.param.rule.CreateRuleParam;
import cn.com.duiba.cloud.risk.engine.api.param.rule.DeleteRuleParam;
import cn.com.duiba.cloud.risk.engine.api.param.rule.RuleQueryParam;
import cn.com.duiba.cloud.risk.engine.api.param.rule.UpdateRuleParam;
import cn.com.duiba.cloud.risk.engine.api.param.rule.UpdateRuleScoreParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * @Description 规则相关
 * @Author dangcang
 * @Date 2022/1/26 11:00 上午
 **/
@AdvancedFeignClient
public interface RemoteRuleService {

    /**
     * 新建规则
     * @param param
     * @return
     * @throws BizException
     */
    Boolean createRule(CreateRuleParam param) throws BizException;

    /**
     * 删除规则
     * @param param
     * @return
     * @throws BizException
     */
    Boolean deleteRule(DeleteRuleParam param) throws BizException;

    /**
     * 上下线规则
     * @param ruleId
     * @param enable
     * @see cn.com.duiba.cloud.risk.engine.api.constants.enums.EnableStatusEnum
     * @return
     * @throws BizException
     */
    Boolean offlineRule(Long ruleId, Integer enable) throws BizException;

    /**
     * 更新规则
     * @param param
     * @return
     * @throws BizException
     */
    Boolean updateRule(UpdateRuleParam param) throws BizException;

    /**
     * 仅更新规则风险分
     * @param param
     * @return
     * @throws BizException
     */
    Boolean updateRuleScoreParam(UpdateRuleScoreParam param) throws BizException;

    /**
     * 规则分页查询
     * @param param
     * @return
     * @throws BizException
     */
    PageResponse<PageRuleDTO> find(RuleQueryParam param) throws BizException;

    /**
     * 查询规则详情
     * @param ruleId
     * @return
     * @throws BizException
     */
    RuleDetailDTO ruleDetail(Long ruleId) throws BizException;
}