package cn.com.duiba.cloud.risk.engine.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.risk.engine.api.dto.strategy.RemoteStrategyStreamListDTO;
import cn.com.duiba.cloud.risk.engine.api.dto.strategy.StrategyStreamDTO;
import cn.com.duiba.cloud.risk.engine.api.param.RemoteBaseParam;
import cn.com.duiba.cloud.risk.engine.api.param.strategy.RemoteDelStrategyNodeParam;
import cn.com.duiba.cloud.risk.engine.api.param.strategy.RemoteStrategyStreamParam;
import cn.com.duiba.cloud.risk.engine.api.param.strategy.RemoteUpdateStrategyNodeParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * 远程策略流服务
 *
 * @author zouwx
 * @date 2022/02/05
 */
@AdvancedFeignClient
public interface RemoteStrategyStreamService {


    /**
     * 策略流分页查询
     *
     * @param remoteStrategyStreamParam 远程战略流页面参数
     * @return {@link PageResponse}<{@link StrategyStreamDTO}>
     * @throws BizException 业务异常
     */
    PageResponse<StrategyStreamDTO> findStrategyStreamList(RemoteStrategyStreamParam remoteStrategyStreamParam) throws BizException;


    /**
     * 查询策略流详情
     *
     * @param remoteBaseParam 远程基础参数
     * @return {@link StrategyStreamDTO}
     * @throws BizException 业务异常
     */
    StrategyStreamDTO findStrategyStreamDetail(RemoteBaseParam remoteBaseParam) throws BizException;

    /**
     * 删除策略流节点
     *
     * @param remoteDelStrategyNodeParam 远程del策略节点参数
     * @return {@link Boolean}
     * @throws BizException 业务异常
     */
    Boolean delStrategyStreamNode(RemoteDelStrategyNodeParam remoteDelStrategyNodeParam) throws BizException;

    /**
     * 更新流程节点
     *
     * @param remoteUpdateStrategyNodeParam 远程更新策略节点参数
     * @return {@link Boolean}
     * @throws BizException 业务异常
     */
    Boolean updateStreamNode(RemoteUpdateStrategyNodeParam remoteUpdateStrategyNodeParam) throws BizException;
}
