/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.consumer;

import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.enums.SentinelConfigTypeEnum;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(prefix="duiba.sentinel", name={"enable"}, havingValue="true")
@RocketMQMessageListener(topic="duiba-sentinel-notice", consumerGroup="sentinel-notice-group", selectorExpression="${duiba.sentinel.namespace}", messageModel=MessageModel.BROADCASTING)
@Component
public class SentinelNoticeConsumer
implements RocketMQListener<String> {
    private static final Logger log = LoggerFactory.getLogger(SentinelNoticeConsumer.class);

    public void onMessage(String message) {
        log.info("\u63a5\u6536QM\u6d88\u606f\u6210\u529f message:{} ", (Object)message);
        if (StringUtils.isBlank((CharSequence)message)) {
            log.error("\u6d88\u606f\u63a8\u9001\u4e8b\u4ef6\u5904\u7406\u5931\u8d25\uff0c\u6d88\u606f\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5 message:{}", (Object)message);
            return;
        }
        JSONObject msgJson = JSON.parseObject((String)message);
        String content = msgJson.getString("content");
        Integer configType = msgJson.getInteger("configType");
        if (SentinelConfigTypeEnum.FLOW_RULE.getValue().equals(configType)) {
            List rules = FlowRuleManager.getRules();
            rules.add(JSON.parseObject((String)content, FlowRule.class));
            FlowRuleManager.loadRules((List)rules);
        }
    }
}

