package cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.enums;

import lombok.Getter;

/**
 * 限流相关配置类型
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/12/27 10:12 上午
 **/
@Getter
public enum SentinelConfigTypeEnum {

    /**
     * 配置类型
     */
    FLOW_RULE(1, "限流规则"),
    FLOW_RULE_DELETE(11, "删除限流规则"),
    PARAM_FLOW_RULE(2, "热点限流规则"),
    TOKEN_SERVER_INFO(3, "token-server信息"),
    ;


    private Integer value;

    private String desc;

    SentinelConfigTypeEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (SentinelConfigTypeEnum item : SentinelConfigTypeEnum.values()) {
            if (item.value == value) {
                return item.desc;
            }
        }
        return "";
    }

    public static SentinelConfigTypeEnum valueOf(Integer value) {
        for (SentinelConfigTypeEnum param : values()) {
            if (param.getValue().equals(value)) {
                return param;
            }
        }
        return null;
    }

    public byte getByteValue() {
        return value.byteValue();
    }
}
