/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.cluster.client;

import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.cluster.client.NettyTransportClient;
import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.cluster.client.config.ClusterClientAssignConfig;
import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.cluster.client.config.ClusterClientConfigManager;
import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.cluster.client.config.ServerChangeObserver;
import com.alibaba.csp.sentinel.cluster.ClusterTransportClient;
import com.alibaba.csp.sentinel.cluster.TokenResult;
import com.alibaba.csp.sentinel.cluster.TokenServerDescriptor;
import com.alibaba.csp.sentinel.cluster.client.ClusterTokenClient;
import com.alibaba.csp.sentinel.cluster.log.ClusterClientStatLogUtil;
import com.alibaba.csp.sentinel.cluster.request.ClusterRequest;
import com.alibaba.csp.sentinel.cluster.request.data.FlowRequestData;
import com.alibaba.csp.sentinel.cluster.request.data.ParamFlowRequestData;
import com.alibaba.csp.sentinel.cluster.response.ClusterResponse;
import com.alibaba.csp.sentinel.cluster.response.data.FlowTokenResponseData;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;

public class DefaultClusterTokenClient
implements ClusterTokenClient {
    private ClusterTransportClient transportClient;
    private TokenServerDescriptor serverDescriptor;
    private final AtomicBoolean shouldStart = new AtomicBoolean(false);

    public DefaultClusterTokenClient() {
        ClusterClientConfigManager.addServerChangeObserver(new ServerChangeObserver(){

            @Override
            public void onRemoteServerChange(ClusterClientAssignConfig assignConfig) {
                DefaultClusterTokenClient.this.changeServer(assignConfig);
            }
        });
        this.initNewConnection();
    }

    private boolean serverEqual(TokenServerDescriptor descriptor, ClusterClientAssignConfig config) {
        if (descriptor == null || config == null) {
            return false;
        }
        return descriptor.getHost().equals(config.getServerHost()) && descriptor.getPort() == config.getServerPort().intValue();
    }

    private void initNewConnection() {
        if (this.transportClient != null) {
            return;
        }
        String host = ClusterClientConfigManager.getServerHost();
        int port = ClusterClientConfigManager.getServerPort();
        if (StringUtil.isBlank((String)host) || port <= 0) {
            return;
        }
        try {
            this.transportClient = new NettyTransportClient(host, port);
            this.serverDescriptor = new TokenServerDescriptor(host, port);
            RecordLog.info((String)("[DefaultClusterTokenClient] New client created: " + this.serverDescriptor), (Object[])new Object[0]);
        }
        catch (Exception ex) {
            RecordLog.warn((String)"[DefaultClusterTokenClient] Failed to initialize new token client", (Throwable)ex);
        }
    }

    private void changeServer(ClusterClientAssignConfig config) {
        if (this.serverEqual(this.serverDescriptor, config)) {
            return;
        }
        try {
            if (this.transportClient != null) {
                this.transportClient.stop();
            }
            this.transportClient = new NettyTransportClient(config.getServerHost(), config.getServerPort());
            this.serverDescriptor = new TokenServerDescriptor(config.getServerHost(), config.getServerPort().intValue());
            this.startClientIfScheduled();
            RecordLog.info((String)("[DefaultClusterTokenClient] New client created: " + this.serverDescriptor), (Object[])new Object[0]);
        }
        catch (Exception ex) {
            RecordLog.warn((String)"[DefaultClusterTokenClient] Failed to change remote token server", (Throwable)ex);
        }
    }

    private void startClientIfScheduled() throws Exception {
        if (this.shouldStart.get()) {
            if (this.transportClient != null) {
                this.transportClient.start();
            } else {
                RecordLog.warn((String)"[DefaultClusterTokenClient] Cannot start transport client: client not created", (Object[])new Object[0]);
            }
        }
    }

    private void stopClientIfStarted() throws Exception {
        if (this.shouldStart.compareAndSet(true, false) && this.transportClient != null) {
            this.transportClient.stop();
        }
    }

    public void start() throws Exception {
        if (this.shouldStart.compareAndSet(false, true)) {
            this.startClientIfScheduled();
        }
    }

    public void stop() throws Exception {
        this.stopClientIfStarted();
    }

    public int getState() {
        if (this.transportClient == null) {
            return 0;
        }
        return this.transportClient.isReady() ? 2 : 0;
    }

    public TokenServerDescriptor currentServer() {
        return this.serverDescriptor;
    }

    public TokenResult requestToken(Long flowId, int acquireCount, boolean prioritized) {
        if (this.notValidRequest(flowId, acquireCount)) {
            return this.badRequest();
        }
        FlowRequestData data = new FlowRequestData().setCount(acquireCount).setFlowId(flowId.longValue()).setPriority(prioritized);
        ClusterRequest request = new ClusterRequest(1, (Object)data);
        try {
            TokenResult result = this.sendTokenRequest(request);
            this.logForResult(result);
            return result;
        }
        catch (Exception ex) {
            ClusterClientStatLogUtil.log((String)ex.getMessage());
            return new TokenResult(Integer.valueOf(-1));
        }
    }

    public TokenResult requestParamToken(Long flowId, int acquireCount, Collection<Object> params) {
        if (this.notValidRequest(flowId, acquireCount) || params == null || params.isEmpty()) {
            return this.badRequest();
        }
        ParamFlowRequestData data = new ParamFlowRequestData().setCount(acquireCount).setFlowId(flowId.longValue()).setParams(params);
        ClusterRequest request = new ClusterRequest(2, (Object)data);
        try {
            TokenResult result = this.sendTokenRequest(request);
            this.logForResult(result);
            return result;
        }
        catch (Exception ex) {
            ClusterClientStatLogUtil.log((String)ex.getMessage());
            return new TokenResult(Integer.valueOf(-1));
        }
    }

    private void logForResult(TokenResult result) {
        switch (result.getStatus()) {
            case 3: {
                ClusterClientStatLogUtil.log((String)"no rules in token server");
                break;
            }
            case -2: {
                ClusterClientStatLogUtil.log((String)"too many requests (client side)");
                break;
            }
        }
    }

    private TokenResult sendTokenRequest(ClusterRequest request) throws Exception {
        if (this.transportClient == null) {
            RecordLog.warn((String)"[DefaultClusterTokenClient] Client not created, please check your config for cluster client", (Object[])new Object[0]);
            return this.clientFail();
        }
        ClusterResponse response = this.transportClient.sendRequest(request);
        TokenResult result = new TokenResult(Integer.valueOf(response.getStatus()));
        if (response.getData() != null) {
            FlowTokenResponseData responseData = (FlowTokenResponseData)response.getData();
            result.setRemaining(responseData.getRemainingCount()).setWaitInMs(responseData.getWaitInMs());
        }
        return result;
    }

    private boolean notValidRequest(Long id, int count) {
        return id == null || id <= 0L || count <= 0;
    }

    private TokenResult badRequest() {
        return new TokenResult(Integer.valueOf(-4));
    }

    private TokenResult clientFail() {
        return new TokenResult(Integer.valueOf(-1));
    }
}

