/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.cluster.client.codec.entity;

import com.alibaba.csp.sentinel.cluster.codec.EntityWriter;
import com.alibaba.csp.sentinel.cluster.request.data.ParamFlowRequestData;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.AssertUtil;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ParamFlowRequestDataWriter
implements EntityWriter<ParamFlowRequestData, ByteBuf> {
    private final int maxParamByteSize;
    private static final int DEFAULT_PARAM_MAX_SIZE = 1024;

    public ParamFlowRequestDataWriter() {
        this(1024);
    }

    public ParamFlowRequestDataWriter(int maxParamByteSize) {
        AssertUtil.isTrue((maxParamByteSize > 0 ? 1 : 0) != 0, (String)"maxParamByteSize should be positive");
        this.maxParamByteSize = maxParamByteSize;
    }

    public void writeTo(ParamFlowRequestData entity, ByteBuf target) {
        target.writeLong(entity.getFlowId());
        target.writeInt(entity.getCount());
        List<Object> params = entity.getParams();
        params = this.resolveValidParams((Collection<Object>)params);
        target.writeInt(params.size());
        for (Object e : params) {
            this.encodeValue(e, target);
        }
    }

    public List<Object> resolveValidParams(Collection<Object> params) {
        ArrayList<Object> validParams = new ArrayList<Object>();
        int size = 0;
        for (Object param : params) {
            int s = this.calculateParamTransportSize(param);
            if (s <= 0) {
                RecordLog.warn((String)("[ParamFlowRequestDataWriter] WARN: Non-primitive type detected in params of cluster parameter flow control, which is not supported: " + param), (Object[])new Object[0]);
                continue;
            }
            if (size + s > this.maxParamByteSize) {
                RecordLog.warn((String)("[ParamFlowRequestDataWriter] WARN: params size is too big. the configure value is : " + this.maxParamByteSize + ", the params size is: " + params.size()), (Object[])new Object[0]);
                break;
            }
            size += s;
            validParams.add(param);
        }
        return validParams;
    }

    private void encodeValue(Object param, ByteBuf target) {
        if (param instanceof Integer || Integer.TYPE.isInstance(param)) {
            target.writeByte(0);
            target.writeInt(((Integer)param).intValue());
        } else if (param instanceof String) {
            this.encodeString((String)param, target);
        } else if (Boolean.TYPE.isInstance(param) || param instanceof Boolean) {
            target.writeByte(6);
            target.writeBoolean(((Boolean)param).booleanValue());
        } else if (Long.TYPE.isInstance(param) || param instanceof Long) {
            target.writeByte(1);
            target.writeLong(((Long)param).longValue());
        } else if (Double.TYPE.isInstance(param) || param instanceof Double) {
            target.writeByte(3);
            target.writeDouble(((Double)param).doubleValue());
        } else if (Float.TYPE.isInstance(param) || param instanceof Float) {
            target.writeByte(4);
            target.writeFloat(((Float)param).floatValue());
        } else if (Byte.TYPE.isInstance(param) || param instanceof Byte) {
            target.writeByte(2);
            target.writeByte((int)((Byte)param).byteValue());
        } else if (Short.TYPE.isInstance(param) || param instanceof Short) {
            target.writeByte(5);
            target.writeShort((int)((Short)param).shortValue());
        }
    }

    private void encodeString(String param, ByteBuf target) {
        target.writeByte(7);
        byte[] tmpChars = param.getBytes();
        target.writeInt(tmpChars.length);
        target.writeBytes(tmpChars);
    }

    int calculateParamTransportSize(Object value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof Integer || Integer.TYPE.isInstance(value)) {
            return 5;
        }
        if (value instanceof String) {
            String tmpValue = (String)value;
            byte[] tmpChars = tmpValue.getBytes();
            return 5 + tmpChars.length;
        }
        if (Boolean.TYPE.isInstance(value) || value instanceof Boolean) {
            return 2;
        }
        if (Long.TYPE.isInstance(value) || value instanceof Long) {
            return 9;
        }
        if (Double.TYPE.isInstance(value) || value instanceof Double) {
            return 9;
        }
        if (Float.TYPE.isInstance(value) || value instanceof Float) {
            return 5;
        }
        if (Byte.TYPE.isInstance(value) || value instanceof Byte) {
            return 2;
        }
        if (Short.TYPE.isInstance(value) || value instanceof Short) {
            return 3;
        }
        return 0;
    }
}

