/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.command.handler;

import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.cluster.client.config.ClusterClientConfigManager;
import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.command.entity.ClusterClientStateEntity;
import com.alibaba.csp.sentinel.command.CommandHandler;
import com.alibaba.csp.sentinel.command.CommandRequest;
import com.alibaba.csp.sentinel.command.CommandResponse;
import com.alibaba.csp.sentinel.command.annotation.CommandMapping;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSON;
import java.net.URLDecoder;

@CommandMapping(name="cluster/client/modifyConfig", desc="modify cluster client config")
public class ModifyClusterClientConfigHandler
implements CommandHandler<String> {
    public CommandResponse<String> handle(CommandRequest request) {
        String data = request.getParam("data");
        if (StringUtil.isBlank((String)data)) {
            return CommandResponse.ofFailure((Throwable)new IllegalArgumentException("empty data"));
        }
        try {
            data = URLDecoder.decode(data, "utf-8");
            RecordLog.info((String)("[ModifyClusterClientConfigHandler] Receiving cluster client config: " + data), (Object[])new Object[0]);
            ClusterClientStateEntity entity = (ClusterClientStateEntity)JSON.parseObject((String)data, ClusterClientStateEntity.class);
            ClusterClientConfigManager.applyNewConfig(entity.toClientConfig());
            ClusterClientConfigManager.applyNewAssignConfig(entity.toAssignConfig());
            return CommandResponse.ofSuccess((Object)"success");
        }
        catch (Exception e) {
            RecordLog.warn((String)"[ModifyClusterClientConfigHandler] Decode client cluster config error", (Throwable)e);
            return CommandResponse.ofFailure((Throwable)e, (Object)"decode client cluster config error");
        }
    }
}

