/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.config;

import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.cluster.client.config.ClusterClientAssignConfig;
import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.cluster.client.config.ClusterClientConfig;
import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.cluster.client.config.ClusterClientConfigManager;
import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.config.DuibaSentinelDataSource;
import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.config.OpenSentinelAutoConfiguration;
import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.consumer.SentinelNoticeConsumer;
import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.enums.SentinelConfigTypeEnum;
import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.param.ClusterGroupParam;
import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.param.ConfigTypeQueryParam;
import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.remoteservice.RemoteRuleConfigService;
import com.alibaba.csp.sentinel.cluster.ClusterStateManager;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRuleManager;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Configuration
@Import(value={SentinelNoticeConsumer.class, OpenSentinelAutoConfiguration.class})
@ConditionalOnProperty(prefix="duiba.sentinel", name={"enable"}, havingValue="true")
public class SentinelClientAutoConfig
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(SentinelClientAutoConfig.class);
    @Value(value="${duiba.sentinel.namespace}")
    private String namespace;
    @Value(value="${duiba.sentinel.request.timeout}")
    private Integer requestTimeOut;
    @Autowired
    private RemoteRuleConfigService remoteRuleConfigService;

    public void run(ApplicationArguments args) throws Exception {
        this.initClusterState();
        this.initClientServerAssignProperty();
        this.initClientRules();
        this.initClientConfigProperty();
    }

    private void initClusterState() {
        ClusterStateManager.applyState((Integer)0);
    }

    private void initClientServerAssignProperty() {
        DuibaSentinelDataSource clientAssignDs = new DuibaSentinelDataSource("", source -> {
            List groupList = (List)JSON.parseObject((String)source, (TypeReference)new TypeReference<List<ClusterGroupParam>>(){}, (Feature[])new Feature[0]);
            return Optional.ofNullable(groupList).flatMap(this::extractClientAssignment).orElse(null);
        });
        ClusterClientConfigManager.registerServerAssignProperty((SentinelProperty<ClusterClientAssignConfig>)clientAssignDs.getProperty());
        ClusterClientConfigManager.applyNewAssignConfig(new ClusterClientAssignConfig("127.0.0.1", 18730));
    }

    private void initClientConfigProperty() {
        DuibaSentinelDataSource ds = new DuibaSentinelDataSource("duiba-sentinel-server:cluster-client-config", source -> (ClusterClientConfig)JSON.parseObject((String)source, (TypeReference)new TypeReference<ClusterClientConfig>(){}, (Feature[])new Feature[0]));
        ClusterClientConfig config = new ClusterClientConfig();
        config.setRequestTimeout(this.requestTimeOut == null ? 100 : this.requestTimeOut);
        ds.getProperty().updateValue((Object)config);
        ClusterClientConfigManager.registerClientConfigProperty((SentinelProperty<ClusterClientConfig>)ds.getProperty());
    }

    private void initClientRules() throws Exception {
        String key = "duiba-sentinel-server:{namespace}-flow-rules".replace("{namespace}", this.namespace);
        ConfigTypeQueryParam param = ConfigTypeQueryParam.builder().configType(SentinelConfigTypeEnum.FLOW_RULE.getValue()).key(key).build();
        String config = this.remoteRuleConfigService.getSentinelConfig(param);
        if (StringUtils.isEmpty((Object)config)) {
            return;
        }
        DuibaSentinelDataSource ds = new DuibaSentinelDataSource(config, source -> (List)JSON.parseObject((String)source, (TypeReference)new TypeReference<List<FlowRule>>(){}, (Feature[])new Feature[0]));
        FlowRuleManager.register2Property((SentinelProperty)ds.getProperty());
        String paramKey = "duiba-sentinel-server:{namespace}-param-flow-rules".replace("{namespace}", this.namespace);
        ConfigTypeQueryParam param2 = ConfigTypeQueryParam.builder().configType(SentinelConfigTypeEnum.PARAM_FLOW_RULE.getValue()).key(paramKey).build();
        String paramConfig = this.remoteRuleConfigService.getSentinelConfig(param2);
        if (StringUtils.isEmpty((Object)config)) {
            return;
        }
        DuibaSentinelDataSource paramDs = new DuibaSentinelDataSource(paramConfig, source -> (List)JSON.parseObject((String)source, (TypeReference)new TypeReference<List<ParamFlowRule>>(){}, (Feature[])new Feature[0]));
        ParamFlowRuleManager.register2Property((SentinelProperty)paramDs.getProperty());
    }

    private Optional<ClusterClientAssignConfig> extractClientAssignment(List<ClusterGroupParam> groupList) {
        if (CollectionUtils.isEmpty(groupList)) {
            return Optional.empty();
        }
        ClusterGroupParam group = groupList.get(0);
        return Optional.of(new ClusterClientAssignConfig(group.getIp(), group.getPort()));
    }
}

