/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.consumer;

import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.cluster.client.config.ClusterClientAssignConfig;
import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.cluster.client.config.ClusterClientConfigManager;
import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.dto.TokenServiceConfigDTO;
import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.enums.SentinelConfigTypeEnum;
import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.param.ConfigNoticeParam;
import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.param.FlowRuleDeleteParam;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRuleManager;
import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@RocketMQMessageListener(topic="duiba-sentinel-notice", consumerGroup="sentinel-notice-group", selectorExpression="*", messageModel=MessageModel.BROADCASTING)
@ConditionalOnProperty(prefix="duiba.sentinel", name={"enable"}, havingValue="true")
@Component
public class SentinelNoticeConsumer
implements RocketMQListener<String> {
    private static final Logger log = LoggerFactory.getLogger(SentinelNoticeConsumer.class);
    @Value(value="${duiba.sentinel.namespace}")
    private String namespace;

    public void onMessage(String message) {
        log.info("\u63a5\u6536QM\u6d88\u606f\u6210\u529f message:{} ", (Object)message);
        if (StringUtils.isBlank((CharSequence)message)) {
            log.error("\u6d88\u606f\u63a8\u9001\u4e8b\u4ef6\u5904\u7406\u5931\u8d25\uff0c\u6d88\u606f\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5 message:{}", (Object)message);
            return;
        }
        ConfigNoticeParam noticeParam = (ConfigNoticeParam)JSON.parseObject((String)message, ConfigNoticeParam.class);
        if (noticeParam == null) {
            return;
        }
        if (!(SentinelConfigTypeEnum.TOKEN_SERVER_INFO.getValue().equals(noticeParam.getConfigType()) || SentinelConfigTypeEnum.TOKEN_SERVER_OFFLINE.getValue().equals(noticeParam.getConfigType()) || noticeParam.getNamespace().equals(this.namespace))) {
            log.info("\u975e\u8be5namespace\u6d88\u606f\u8df3\u8fc7\u5904\u7406");
            return;
        }
        if (SentinelConfigTypeEnum.FLOW_RULE.getValue().equals(noticeParam.getConfigType())) {
            FlowRule newFlowRule = (FlowRule)JSON.parseObject((String)noticeParam.getContent(), FlowRule.class);
            List rules = FlowRuleManager.getRules();
            List curRules = rules.stream().filter(item -> !item.getResource().equals(newFlowRule.getResource())).collect(Collectors.toList());
            curRules.add(newFlowRule);
            FlowRuleManager.loadRules(curRules);
        } else if (SentinelConfigTypeEnum.FLOW_RULE_DELETE.getValue().equals(noticeParam.getConfigType())) {
            FlowRuleDeleteParam deleteParam = (FlowRuleDeleteParam)JSON.parseObject((String)noticeParam.getContent(), FlowRuleDeleteParam.class);
            List flowRules = FlowRuleManager.getRules();
            flowRules = flowRules.stream().filter(item -> !item.getResource().equals(deleteParam.getResource())).collect(Collectors.toList());
            FlowRuleManager.loadRules(flowRules);
        } else if (SentinelConfigTypeEnum.PARAM_FLOW_RULE.getValue().equals(noticeParam.getConfigType())) {
            ParamFlowRule newFlowRule = (ParamFlowRule)JSON.parseObject((String)noticeParam.getContent(), ParamFlowRule.class);
            List rules = ParamFlowRuleManager.getRules();
            List curRules = rules.stream().filter(item -> !item.getResource().equals(newFlowRule.getResource())).collect(Collectors.toList());
            curRules.add(newFlowRule);
            ParamFlowRuleManager.loadRules(curRules);
        } else if (SentinelConfigTypeEnum.PARAM_FLOW_RULE_DELETE.getValue().equals(noticeParam.getConfigType())) {
            FlowRuleDeleteParam deleteParam = (FlowRuleDeleteParam)JSON.parseObject((String)noticeParam.getContent(), FlowRuleDeleteParam.class);
            List flowRules = ParamFlowRuleManager.getRules();
            flowRules = flowRules.stream().filter(item -> !item.getResource().equals(deleteParam.getResource())).collect(Collectors.toList());
            ParamFlowRuleManager.loadRules(flowRules);
        } else if (SentinelConfigTypeEnum.TOKEN_SERVER_INFO.getValue().equals(noticeParam.getConfigType())) {
            TokenServiceConfigDTO serviceConfigDTO = (TokenServiceConfigDTO)JSON.parseObject((String)noticeParam.getContent(), TokenServiceConfigDTO.class);
            ClusterClientConfigManager.applyNewAssignConfig(new ClusterClientAssignConfig(serviceConfigDTO.getHost(), serviceConfigDTO.getPort()));
        } else if (SentinelConfigTypeEnum.TOKEN_SERVER_OFFLINE.getValue().equals(noticeParam.getConfigType())) {
            TokenServiceConfigDTO serviceConfigDTO = (TokenServiceConfigDTO)JSON.parseObject((String)noticeParam.getContent(), TokenServiceConfigDTO.class);
            ClusterClientConfigManager.applyNewAssignConfig(new ClusterClientAssignConfig(serviceConfigDTO.getHost(), serviceConfigDTO.getPort()));
        }
    }
}

