/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.stock.service.api.enums;

import cn.hutool.core.util.StrUtil;
import java.util.stream.Stream;

public enum StockTypeEnum {
    ACTUAL_STOCK("actualStock", "\u771f\u5b9e\u5e93\u5b58", "business_platform_actual_stock", null),
    LIMIT_STOCK("limitStock", "\u9650\u8d2d\u5e93\u5b58", "business_platform_limit_stock", 2),
    ASSIGN_STOCK("assignStock", "\u9884\u5360\u5e93\u5b58", "business_platform_assign_stock", 1),
    LOT_STOCK("lotStock", "\u6279\u6b21\u5e93\u5b58", "business_platform_lot_stock", null);

    private String type;
    private String desc;
    private String measureType;
    private Integer idMark;

    public static StockTypeEnum getStockTypeByType(String type) {
        return Stream.of(StockTypeEnum.values()).filter(t -> StrUtil.equals((CharSequence)t.type, (CharSequence)type)).findFirst().orElse(null);
    }

    private StockTypeEnum(String type, String desc, String measureType, Integer idMark) {
        this.type = type;
        this.desc = desc;
        this.measureType = measureType;
        this.idMark = idMark;
    }

    public String getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getMeasureType() {
        return this.measureType;
    }

    public Integer getIdMark() {
        return this.idMark;
    }
}

