/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.stock.service.api.enums.stock;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;
import java.util.Objects;
import java.util.stream.Stream;

public enum StockFlowTypeEnum implements IEnum<Integer>
{
    ORDER(1, "\u9500\u552e\u8ba2\u5355"),
    INIT(2, "\u5e93\u5b58\u521d\u59cb\u5316"),
    UPDATE(3, "\u4fee\u6539\u5e93\u5b58"),
    DISPATCH(4, "\u8c03\u5ea6\u5e93\u5b58"),
    ACTIVITY(5, "\u6d3b\u52a8\u8ba2\u5355"),
    ROLLBACK(6, "\u8fd4\u5e93");

    private Integer dbCode;
    private String desc;

    public static Boolean checkHasType(Integer idMark) {
        return Stream.of(StockFlowTypeEnum.values()).anyMatch(v -> Objects.equals(v.getDbCode(), idMark));
    }

    public static StockFlowTypeEnum getFlowTypeByIdMark(Integer idMark) {
        return Stream.of(StockFlowTypeEnum.values()).filter(v -> Objects.equals(v.getDbCode(), idMark)).findFirst().orElse(null);
    }

    public Integer getDbCode() {
        return this.dbCode;
    }

    public String getDesc() {
        return this.desc;
    }

    private StockFlowTypeEnum(Integer dbCode, String desc) {
        this.dbCode = dbCode;
        this.desc = desc;
    }
}

