package cn.com.duiba.cloud.stock.service.api.dto.stock;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * 修改库存结果dto
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/11/23 8:30 下午
 **/
@Data
@Accessors(chain = true)
public class ConsumeStockResultDTO implements Serializable {
    private static final long serialVersionUID = 9078103549190367608L;

    /**
     * skuId
     */
    private Long skuId;

    /**
     * 修改库存子结果
     */
    private List<ConsumeStockSubResultDTO> consumeStockSubResultDTOList;

    @Data
    @Accessors(chain = true)
    public static class ConsumeStockSubResultDTO implements Serializable {
        private static final long serialVersionUID = -3844130268190111540L;

        /**
         * 库存流水号
         */
        private String flowNo;

        /**
         * sku渠道id
         */
        private Long skuChannelId;
    }
}