package cn.com.duiba.cloud.stock.service.api.param.channel;

import cn.com.duiba.cloud.stock.service.api.param.stock.StockParam;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * spu渠道请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/11/24 6:11 下午
 **/
@Data
@Accessors(chain = true)
public class ChannelParam implements Serializable {
    private static final long serialVersionUID = 3737751104363305467L;

    /**
     * spuID
     */
    @NotNull
    private Long spuId;

    /**
     * 商品名称
     */
    @NotBlank
    private String spuName;

    /**
     * 商品类型
     */
    @NotNull
    private Integer spuType;

    /**
     * 类目id
     */
    @NotNull
    private Long categoryId;

    /**
     * 用户ID
     */
    @NotNull
    private Long userId;

    /**
     * 用户类型(1:平台;2:租户;3:用户)
     */
    @NotNull
    private Integer userType;

    /**
     * 是否可用
     */
    @NotNull
    private Integer isUsable;

    /**
     * 修改库存请求列表参数
     */
    @NotNull
    private List<StockParam> stockParamList;
}