package cn.com.duiba.cloud.stock.service.api.param.channel;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * spu渠道查询参数
 *
 * @author zhoujunquan
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
public class SpuChannelQueryParam extends PageRequest implements Serializable {
    private static final long serialVersionUID = -1247873056674930109L;
    /**
     * spuId
     */
    private Long spuId;

    /**
     * 用户ID
     */
    @NotBlank
    private Long userId;

    /**
     * 用户类型(1:平台;2:租户;3:用户)
     */
    @NotBlank
    private Integer userType;

    /**
     * 商品类型
     */
    private Integer spuType;

    /**
     * 类目id
     */
    private Long categoryId;

    /**
     * 商品名称
     */
    private String spuName;

    /**
     * 是否可用
     */
    private Integer isUsable;

    /**
     * 商品来源idList
     */
    private Long sourceId;
}