package cn.com.duiba.cloud.stock.service.api.param.stock;

import cn.com.duiba.cloud.stock.service.api.enums.stock.StockFlowTypeEnum;
import cn.com.duiba.cloud.stock.service.api.enums.stock.StockOccupyEnum;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 消耗库存请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/11/25 4:52 下午
 **/
@Data
@Accessors(chain = true)
public class ConsumeStockParam implements Serializable {
    private static final long serialVersionUID = 7189730764651444236L;

    /**
     * 预占场景泛id，如活动id
     */
    private Long generalId;

    /**
     * 预占场景泛类型，{@link StockOccupyEnum}
     */
    private Integer generalType;

    /**
     * 当前租户用户id
     */
    @NotNull
    private Long userId;

    /**
     * 当前租户用户类型
     * 用户类型(1:平台;2:租户;3:用户)
     */
    @NotNull
    private Integer userType;

    /**
     * skuId
     */
    @NotNull
    private Long skuId;

    /**
     * 库存变更值
     */
    @NotNull
    private Long changeValue;

    /**
     * 业务单号
     */
    @NotNull
    private String bizNo;

    /**
     * 业务类型 {@link StockFlowTypeEnum}
     */
    @NotNull
    private Integer bizType;
}