package cn.com.duiba.cloud.stock.service.api.param.stock;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 调度预占库存请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/11/30 11:29 上午
 **/
@Data
@Accessors(chain = true)
@Deprecated
public class DispatchOccupyStockParam implements Serializable {
    private static final long serialVersionUID = 8757685987768956521L;

    /**
     * 调度作用域id 如活动id
     */
    @NotNull
    private Long generalId;

    /**
     * 调度作用域类型 {@link cn.com.duiba.cloud.stock.service.api.enums.stock.StockOccupyEnum}
     */
    @NotNull
    private Integer generalType;

    /**
     * 库存id（只有预采购类型或自营的库存）
     */
    @NotNull
    private Long stockId;

    /**
     * 调度值
     */
    @NotNull
    private Long dispatchValue;

    /**
     * 用户id
     */
    @NotNull
    private Long userId;

    /**
     * 用户类型(1:平台;2:租户;3:用户)
     */
    @NotNull
    private Integer userType;
}