package cn.com.duiba.cloud.stock.service.api.param.stock;

import cn.com.duiba.cloud.stock.service.api.enums.stock.StockOccupyEnum;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 根据活动查询预占库存信息请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/11/30 3:47 下午
 **/
@Data
@Accessors(chain = true)
public class QueryStockOccupyParam implements Serializable {
    private static final long serialVersionUID = 5399773111632535202L;

    /**
     * skuId
     */
    @NotNull
    private Long skuId;

    /**
     * 预占场景泛id，如活动id
     */
    @NotNull
    private Long generalId;

    /**
     * 预占场景泛类型，{@link StockOccupyEnum}
     */
    @NotNull
    private Integer generalType;

    /**
     * 当前租户用户id
     */
    @NotNull
    private Long userId;

    /**
     * 当前租户用户类型
     * 用户类型(1:平台;2:租户;3:用户)
     */
    @NotNull
    private Integer userType;
}