package cn.com.duiba.cloud.stock.service.api.param.stock;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 创建批次库存请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/11/23 4:41 下午
 **/
@Data
public class StockLotParam implements Serializable {
    private static final long serialVersionUID = 4970019543790684381L;

    /**
     * 批次库存id
     * 如果是修改批次库存，必传
     */
    private Long id;

    /**
     * 批次顺序
     */
    @NotNull
    private Long lotSort;

    /**
     * 成本价
     */
    @NotNull
    private Long costPrice;

    /**
     * 批号
     */
    @NotNull
    private Long lotNo;

    /**
     * 剩余库存数量
     */
    private Long stockNumber;

    /**
     * 库存变更数
     */
    private Long changeValue;
}