package cn.com.duiba.cloud.stock.service.api.param.stock;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 通过sku获取预占列表库存信息请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/12/8 2:48 下午
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
public class StockOccupyGeneralInfoParam extends PageRequest implements Serializable {
    private static final long serialVersionUID = 7899733971235385765L;

    /**
     * 当前用户id
     */
    @NotNull
    private Long userId;

    /**
     * 当前用户类型(1:平台;2:租户;3:用户)
     */
    @NotNull
    private Integer userType;

    /**
     * skuId
     */
    @NotNull
    private Long skuId;
}