package cn.com.duiba.cloud.stock.service.api.param.stock;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 修改库存状态请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/11/29 4:43 下午
 **/
@Data
@Accessors(chain = true)
public class UpdateStockStatusParam implements Serializable {
    private static final long serialVersionUID = -8594099608017993959L;

    /**
     * 业务单号
     */
    @NotBlank
    private String bizNo;

    /**
     * 业务类型 {@link cn.com.duiba.cloud.stock.service.api.enums.stock.StockFlowTypeEnum}
     */
    @NotNull
    private Integer bizType;

    /**
     * 变更的库存状态 {@link cn.com.duiba.cloud.stock.service.api.enums.stock.StockFlowStatusEnum}
     */
    @NotNull
    private Integer stockStatus;
}