package cn.com.duiba.cloud.stock.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.stock.service.api.dto.channel.SpuChannelDTO;
import cn.com.duiba.cloud.stock.service.api.param.channel.ChannelParam;
import cn.com.duiba.cloud.stock.service.api.param.channel.SpuChannelQueryParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * 库存渠道remote接口
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/11/20 8:45 下午
 **/
@AdvancedFeignClient
public interface RemoteStockChannelService {
    /**
     * 通过条件分页查询spu渠道列表
     * 系统最多只支持两种链路
     * 1：第三方供应商→租户
     * 2：兑吧供应商→兑吧→租户
     * 因此去查询库存的时候，从租户角度，最多只会往上查询两级，超过两级就会抛BizException异常
     *
     * @param spuChannelQueryParam 查询spu渠道列表条件 {@link SpuChannelQueryParam}
     * @return spu渠道列表
     * @throws BizException 业务异常
     */
    PageResponse<SpuChannelDTO> listSpuChannel(SpuChannelQueryParam spuChannelQueryParam) throws BizException;

    /**
     * 创建渠道和库存
     * 只局限于自建商品的场景
     * step1 创建渠道
     * step2 创建库存
     *
     * @param channelParam spu渠道请求参数 {@link ChannelParam}
     * @return spu渠道id
     * @throws BizException 业务异常
     */
    Long createChannel(ChannelParam channelParam) throws BizException;

    /**
     * 修改渠道和库存
     * 只局限于自建商品的场景
     * step1 修改渠道
     * step2 修改库存
     *
     * @param channelParam spu渠道请求参数 {@link ChannelParam}
     * @return true/false
     * @throws BizException 业务异常
     */
    Boolean updateChannel(ChannelParam channelParam) throws BizException;

    /**
     * spu渠道状态开关
     *
     * @param id       spu渠道id
     * @param isUsable 是否可用 1：是，0：否
     * @return true/false
     * @throws BizException 业务异常
     */
    Boolean spuChannelStatusSwitch(Long id, Integer isUsable) throws BizException;
}