package cn.com.duiba.cloud.stock.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.stock.service.api.dto.stock.ConsumeStockResultDTO;
import cn.com.duiba.cloud.stock.service.api.dto.stock.StockDTO;
import cn.com.duiba.cloud.stock.service.api.dto.stock.StockInfoDTO;
import cn.com.duiba.cloud.stock.service.api.dto.stock.StockLotDTO;
import cn.com.duiba.cloud.stock.service.api.dto.stock.StockOccupyGeneralInfoDTO;
import cn.com.duiba.cloud.stock.service.api.dto.stock.StockOccupyInfoDTO;
import cn.com.duiba.cloud.stock.service.api.param.stock.ConsumeStockParam;
import cn.com.duiba.cloud.stock.service.api.param.stock.DispatchOccupyStockParam;
import cn.com.duiba.cloud.stock.service.api.param.stock.QueryStockOccupyParam;
import cn.com.duiba.cloud.stock.service.api.param.stock.StockOccupyGeneralInfoParam;
import cn.com.duiba.cloud.stock.service.api.param.stock.UpdateOccupyStockParam;
import cn.com.duiba.cloud.stock.service.api.param.stock.UpdateStockStatusParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;
import java.util.Map;

/**
 * 库存中心remote接口
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/11/20 1:33 下午
 **/
@AdvancedFeignClient
public interface RemoteStockService {
    /**
     * 通过skuId获取可销售库存
     *
     * @param skuId    skuId
     * @param userId   用户id（上架项的用户id）
     * @param userType 用户类型(上架项的用户类型)
     * @return 可销售库存信息
     * @throws BizException 业务异常
     * @deprecated {@link RemoteStockService#batchGetStockInfo(List, Long, Integer)}
     */
    @Deprecated
    Long getCanSaleStockNumber(Long skuId, Long userId, Integer userType) throws BizException;

    /**
     * 通过skuId批量获取库存信息
     *
     * @param skuIdList skuId列表
     * @param userId    用户id
     * @param userType  用户类型(1:平台;2:租户;3:用户)
     * @return 库存信息 {@link StockInfoDTO}
     * @throws BizException 业务异常
     */
    List<StockInfoDTO> batchGetStockInfo(List<Long> skuIdList, Long userId, Integer userType) throws BizException;

    /**
     * 获取库存信息
     * 只局限于自建库存和预采购库存
     *
     * @param skuId    skuId
     * @param userId   创建商品的用户id
     * @param userType 创建商品的用户类型
     * @return 库存信息
     * @throws BizException 业务异常
     */
    List<StockDTO> getStockInfo(Long skuId, Long userId, Integer userType) throws BizException;

    /**
     * 根据库存id查询库存批次列表
     *
     * @param stockId 库存id
     * @return 库次年批次列表
     * @throws BizException 业务异常
     */
    List<StockLotDTO> listStockLotInfo(Long stockId) throws BizException;


    /**
     * 批量调度预占库存
     *
     * @param dispatchOccupyStockParamList 调度预占库存请求参数列表
     * @return 调度作用域id, 预占库存id
     * @throws BizException 业务异常
     * @deprecated {@link RemoteStockService#updateOccupyStock(cn.com.duiba.cloud.stock.service.api.param.stock.UpdateOccupyStockParam)}
     */
    @Deprecated
    Map<Long, Long> dispatchOccupyStock(List<DispatchOccupyStockParam> dispatchOccupyStockParamList) throws BizException;

    /**
     * 编辑预占库存
     * 场景：新增、减少、删除预占库存都支持
     *
     * @param updateOccupyStockParam 编辑预占库存请求参数
     * @return true/false
     * @throws BizException 业务异常
     */
    Boolean updateOccupyStock(UpdateOccupyStockParam updateOccupyStockParam) throws BizException;

    /**
     * 回退预占库存
     *
     * @param stockOccupyId 预占库存id
     * @return 回退库存数量
     * @throws BizException 业务异常
     * @deprecated {@link RemoteStockService#updateOccupyStock(cn.com.duiba.cloud.stock.service.api.param.stock.UpdateOccupyStockParam)}
     */
    @Deprecated
    Long rollbackOccupyStock(Long stockOccupyId) throws BizException;

    /**
     * 批量消耗库存
     *
     * @param consumeStockParamList 消耗库存请求参数列表
     * @return 变更库存结果 {@link ConsumeStockResultDTO}
     * @throws BizException 业务异常
     */
    List<ConsumeStockResultDTO> consumeStock(List<ConsumeStockParam> consumeStockParamList) throws BizException;

    /**
     * 批量修改库存状态
     *
     * @param updateStockStatusParamList 修改库存状态
     * @return true/false
     * @throws BizException 业务异常
     */
    Boolean batchUpdateStockStatus(List<UpdateStockStatusParam> updateStockStatusParamList) throws BizException;

    /**
     * 根据skuId、预占场景id获取预占库存信息
     *
     * @param queryStockOccupyParamList 查询预占库存信息请求参数列表
     * @return 预占库存信息列表
     * @throws BizException 业务异常
     * @deprecated {@link RemoteStockService#batchGetStockOccupyInfo(java.util.List, java.lang.Long, java.lang.Integer, java.lang.Long, java.lang.Integer)}
     */
    @Deprecated
    List<StockOccupyInfoDTO> queryStockOccupy(List<QueryStockOccupyParam> queryStockOccupyParamList) throws BizException;

    /**
     * 根据skuId、预占场景id批量获取预占库存信息
     *
     * @param skuIdList   skuId列表
     * @param userId      用户id
     * @param userType    用户类型(1:平台;2:租户;3:用户)
     * @param generalId   预占场景id 如活动id
     * @param generalType 预占类型 {@link cn.com.duiba.cloud.stock.service.api.enums.stock.StockOccupyEnum}
     * @return 预占库存信息 {@link StockOccupyInfoDTO}
     * @throws BizException 业务异常
     */
    List<StockOccupyInfoDTO> batchGetStockOccupyInfo(List<Long> skuIdList, Long userId, Integer userType, Long generalId, Integer generalType) throws BizException;

    /**
     * 分页查询预占列表库存信息
     *
     * @param stockOccupyGeneralInfoParam 请求参数 {@link StockOccupyGeneralInfoParam}
     * @return 预占列表库存信息
     * @throws BizException 业务异常
     */
    PageResponse<StockOccupyGeneralInfoDTO> getStockOccupyGeneralInfo(StockOccupyGeneralInfoParam stockOccupyGeneralInfoParam) throws BizException;
}