package cn.com.duiba.cloud.stock.service.api.param.occupy;

import cn.com.duiba.cloud.stock.service.api.enums.stock.StockOccupyEnum;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 返还预占库存请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2021/12/17 5:40 下午
 * @since 0.0.1
 **/
@Data
@Accessors(chain = true)
public class RollbackOccupyStockParam implements Serializable {
    private static final long serialVersionUID = -5909421412751718877L;

    /**
     * 调度作用域id 如活动id
     */
    @NotNull(message = "预占泛id不能为空")
    private Long generalId;

    /**
     * 调度作用域类型 {@link StockOccupyEnum}
     */
    @NotNull(message = "预占类型不能为空")
    private Integer generalType;

    /**
     * 用户id
     */
    @NotNull(message = "userId不能为空")
    private Long userId;

    /**
     * 用户类型(1:平台;2:租户;3:用户)
     */
    @NotNull(message = "用户类型不能为空")
    private Integer userType;
}