package cn.com.duiba.cloud.stock.service.api.param.stock;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 修改库存请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/11/23 4:40 下午
 **/
@Data
@Accessors(chain = true)
public class StockParam implements Serializable {
    private static final long serialVersionUID = -5620493573609820463L;

    /**
     * skuID
     */
    @NotNull(message = "skuId不能为空")
    private Long skuId;

    /**
     * 库存类型(1:实际(真实给货,当前租户发货),2:虚拟(真实给货,顶级供货商发货))
     */
    @NotNull(message = "库存类型不能为空")
    private Integer stockType;

    /**
     * 库存数量
     */
    private Long stockNumber;

    /**
     * 库存变更数
     */
    private Long changeValue;

    /**
     * 成本价（分）
     */
    private Long costPrice;

    /**
     * 是否批次管理(1:是,0:否)
     */
    @NotNull(message = "是否批次管理标识不能为空")
    @Min(value = 0, message = "是否批次管理标识错误")
    @Max(value = 1, message = "是否批次管理标识错误")
    private Integer isLot;

    /**
     * 创建批次库存信息参数
     */
    private List<StockLotParam> stockLotParamList;
}