package cn.com.duiba.cloud.stock.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.stock.service.api.dto.channel.SpuChannelDTO;
import cn.com.duiba.cloud.stock.service.api.param.channel.ChannelParam;
import cn.com.duiba.cloud.stock.service.api.param.channel.SpuChannelQueryParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * 库存渠道remote接口
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/11/20 8:45 下午
 **/
@AdvancedFeignClient
public interface RemoteStockChannelService {
    /**
     * 通过条件分页查询spu渠道列表<br>
     * <p>
     * 系统最多只支持两种链路<br>
     * <ol>
     *     <li>第三方供应商→租户</li>
     *     <li>兑吧供应商→兑吧→租户</li>
     * </ol>
     * 因此去查询库存的时候，从租户角度，最多只会往上查询两级，超过两级就会抛BizException异常
     * </p>
     *
     * @param spuChannelQueryParam 查询spu渠道列表条件 {@link SpuChannelQueryParam}
     * @return spu渠道列表
     * @throws BizException 业务异常
     *                      <ul>
     *                          <li>分页参数不能为空</li>
     *                          <li>不支持多级分销</li>
     *                          <li>库存id列表不能为空</li>
     *                          <li>bizNoList不能为空</li>
     *                      </ul>
     */
    PageResponse<SpuChannelDTO> listSpuChannel(SpuChannelQueryParam spuChannelQueryParam) throws BizException;

    /**
     * 创建渠道和库存<br>
     * 只局限于自建商品的场景
     * <ol>
     *     <li>step1 创建渠道</li>
     *     <li>step2 创建库存</li>
     * </ol>
     *
     * @param channelParam spu渠道请求参数 {@link ChannelParam}
     * @return spu渠道id
     * @throws BizException 业务异常
     *                      <ul>
     *                          <li>商品类型有误</li>
     *                          <li>库存初始值不能为null</li>
     *                          <li>db异常</li>
     *                          <li>批次库存请求参数列表或库存id不能为空</li>
     *                          <li>通过批次库存id:[{}]无法获取批次库存</li>
     *                          <li>新增批次库存不能为空或小于0</li>
     *                          <li>总库存和批次库存之和不相等</li>
     *                      </ul>
     */
    Long createChannel(ChannelParam channelParam) throws BizException;

    /**
     * 修改渠道和库存<br>
     * 只局限于自建商品的场景
     * <ol>
     *     <li>step1 修改渠道</li>
     *     <li>step2 修改库存</li>
     * </ol>
     *
     * @param channelParam spu渠道请求参数 {@link ChannelParam}
     * @return true/false
     * @throws BizException 业务异常
     *                      <ul>
     *                          <li>商品类型有误</li>
     *                          <li>通过spuId:[{}"]无法获取spu渠道</li>
     *                          <li>skuId不能为空</li>
     *                          <li>通过库存id:[{}]无法获取库存信息</li>
     *                          <li>批次库存请求参数列表或库存id不能为空</li>
     *                          <li>通过批次库存id:[{}]无法获取批次库存</li>
     *                          <li>db异常</li>
     *                          <li>新增批次库存不能为空或小于0</li>
     *                          <li>库存变更值和批次库存变更值之和不匹配</li>
     *                          <li>库存初始值不能为null</li>
     *                          <li>新增批次库存不能为空或小于0</li>
     *                          <li>总库存和批次库存之和不相等</li>
     *                      </ul>
     */
    Boolean updateChannel(ChannelParam channelParam) throws BizException;

    /**
     * spu渠道状态开关
     *
     * @param id       spu渠道id
     * @param isUsable 是否可用 1：是，0：否
     * @return true/false
     * @throws BizException 业务异常
     *                      <ul>
     *                          <li>spu渠道id不能为空</li>
     *                          <li>isUsable参数错误</li>
     *                          <li>db异常</li>
     *                      </ul>
     */
    Boolean spuChannelStatusSwitch(Long id, Integer isUsable) throws BizException;
}