package cn.com.duiba.cloud.stock.service.api.param.channel;

import cn.com.duiba.cloud.stock.service.api.param.stock.StockParam;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * spu渠道请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/11/24 6:11 下午
 **/
@Data
@Accessors(chain = true)
public class ChannelParam implements Serializable {
    private static final long serialVersionUID = 3737751104363305467L;

    /**
     * spuID
     */
    @NotNull(message = "spuId不能为空")
    private Long spuId;

    /**
     * 商品名称
     */
    @NotBlank(message = "商品名称不能为空")
    private String spuName;

    /**
     * 商品类型
     */
    @NotNull(message = "商品类型不能为空")
    private Integer spuType;

    /**
     * 类目id
     */
    @NotNull(message = "类目id不能为空")
    private Long categoryId;

    /**
     * 用户ID
     */
    @NotNull(message = "用户id不能为空")
    private Long userId;

    /**
     * 用户类型(1:平台;2:租户;3:用户)
     */
    @NotNull(message = "用户类型不能为空")
    private Integer userType;

    /**
     * 是否可用
     */
    @NotNull(message = "是否可用标识不能为空")
    private Integer isUsable;

    /**
     * 库存请求列表参数
     */
    @NotNull(message = "库存请求列表参数不能为空")
    private List<StockParam> stockParamList;
}