package cn.com.duiba.cloud.stock.service.api.dto.channel;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * spu渠道DTO
 *
 * @author zhoujunquan
 */
@Data
public class SpuChannelDTO implements Serializable {
    private static final long serialVersionUID = -1471129948259668396L;
    /**
     * spu渠道id
     *
     * @deprecated 请使用 {@link SpuChannelDTO#spuChannelId}
     */
    @Deprecated
    private Long id;

    /**
     * spu渠道id
     */
    private Long spuChannelId;

    /**
     * spuID
     */
    private Long spuId;

    /**
     * 商品名称
     */
    private String spuName;

    /**
     * 商品类型
     */
    private Integer spuType;

    /**
     * 是否可用
     */
    private Integer isUsable;

    /**
     * 总库存
     *
     * @deprecated spu渠道列表不展示总库存，而展示可销售库存 {@link SpuChannelDTO#canSaleStockNumber}
     */
    @Deprecated
    private Long stockNumber;

    /**
     * 可销售库存
     */
    private Long canSaleStockNumber;

    /**
     * 最高成本价
     */
    private Long maxPrice;

    /**
     * 最低成本价
     */
    private Long minPrice;

    /**
     * sku渠道列表
     *
     * @deprecated 删除字段
     */
    @Deprecated
    private List<SkuChannelDTO> skuChannelDTOList;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}