package cn.com.duiba.cloud.stock.service.api.dto.stock;

import lombok.Data;

import java.io.Serializable;

/**
 * 真实库存信息
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/11/23 2:54 下午
 **/
@Data
public class StockDTO implements Serializable {
    private static final long serialVersionUID = 3957370226657530602L;

    /**
     * 库存id
     */
    private Long id;

    /**
     * skuID
     */
    private Long skuId;

    /**
     * 库存类型(1:实际(真实给货,当前租户发货),2:虚拟(真实给货,顶级供货商发货))
     */
    private Integer stockType;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 用户类型(1:平台;2:租户;3:用户)
     */
    private Integer userType;

    /**
     * 库存数量
     */
    private Long stockNumber;

    /**
     * 成本价（分）
     */
    private Long costPrice;

    /**
     * 是否批次管理(1:是,0:否)
     */
    private Integer isLot;

    /**
     * 库存父id
     */
    private Long parentStockId;
}