package cn.com.duiba.cloud.stock.service.api.enums.stock;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;
import java.util.stream.Stream;

/**
 * 库存流水业务类型枚举
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/11/23 5:10 下午
 **/
@Getter
@AllArgsConstructor
public enum StockFlowTypeEnum implements IEnum<Integer> {
    /**
     * 销售订单
     */
    ORDER(1, "销售订单", "order"),

    /**
     * 库存初始化
     */
    INIT(2, "库存初始化", "init"),

    /**
     * 修改库存
     */
    UPDATE(3, "修改库存", "update"),

    /**
     * 调度库存
     */
    DISPATCH(4, "调度库存", "dispatch"),

    /**
     * 活动订单
     */
    ACTIVITY(5, "活动订单", "activity"),

    /**
     * 返库
     */
    ROLLBACK(6, "返库", "rollback");

    /**
     * 业务类型id
     */
    private Integer dbCode;

    /**
     * 业务类型描述
     */
    private String desc;

    /**
     * 业务场景标识
     */
    private String scene;

    /**
     * 根据id查询是否存在的业务类型
     *
     * @param idMark id
     * @return true/false
     */
    public static Boolean checkHasType(Integer idMark) {
        return Stream.of(values()).anyMatch(v -> Objects.equals(v.getDbCode(), idMark));
    }

    /**
     * 通过type获取枚举
     *
     * @param idMark id
     * @return StockFlowTypeEnum
     */
    public static StockFlowTypeEnum getFlowTypeByIdMark(Integer idMark) {
        return Stream.of(values()).filter(v -> Objects.equals(v.getDbCode(), idMark)).findFirst().orElse(null);
    }

}