package cn.com.duiba.cloud.stock.service.api.param.stock;

import cn.com.duiba.cloud.stock.service.api.enums.stock.StockOccupyEnum;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 根据活动查询预占库存信息请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/11/30 3:47 下午
 **/
@Data
@Accessors(chain = true)
public class QueryStockOccupyParam implements Serializable {
    private static final long serialVersionUID = 5399773111632535202L;

    /**
     * skuId
     */
    @NotNull(message = "skuId不能为空")
    private Long skuId;

    /**
     * 预占场景泛id，如活动id
     */
    @NotNull(message = "预占泛id不能为空")
    private Long generalId;

    /**
     * 预占场景泛类型，{@link StockOccupyEnum}
     */
    @NotNull(message = "预占类型不能为空")
    private Integer generalType;

    /**
     * 当前租户用户id
     */
    @NotNull(message = "用户id不能为空")
    private Long userId;

    /**
     * 当前租户用户类型<br>
     * 用户类型(1:平台;2:租户;3:用户)
     */
    @NotNull(message = "用户类型不能为空")
    private Integer userType;
}