package cn.com.duiba.cloud.stock.service.api.param.stock;

import cn.com.duiba.cloud.stock.service.api.enums.stock.StockOccupyEnum;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 编辑预占库存请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/11/30 11:29 上午
 **/
@Data
@Accessors(chain = true)
public class UpdateOccupyStockParam implements Serializable {
    private static final long serialVersionUID = 8757685987768956521L;

    /**
     * 调度作用域id 如活动id
     */
    @NotNull(message = "预占泛id不能为空")
    private Long generalId;

    /**
     * 调度作用域类型 {@link StockOccupyEnum}
     */
    @NotNull(message = "预占类型不能为空")
    private Integer generalType;

    /**
     * 用户id
     */
    @NotNull(message = "userId不能为空")
    private Long userId;

    /**
     * 用户类型(1:平台;2:租户;3:用户)
     */
    @NotNull(message = "用户类型不能为空")
    private Integer userType;

    /**
     * 编辑预占库存请求子参数列表
     */
    @NotNull(message = "编辑预占库存请求子参数列表不能为空")
    private List<UpdateOccupyStockSubParam> updateOccupyStockSubParamList;

    @Data
    @Accessors(chain = true)
    public static class UpdateOccupyStockSubParam implements Serializable {
        private static final long serialVersionUID = -4759629936016555024L;

        /**
         * skuId
         */
        @NotNull(message = "skuId不能为空")
        private Long skuId;

        /**
         * 调度值<br>
         * 场景：新增<br>
         * 和changeValue不能同时为null
         */
        private Long dispatchValue;

        /**
         * 更新值<br>
         * 场景：新增或减少<br>
         * 和dispatchValue不能同时为null
         */
        private Long changeValue;
    }
}