package cn.com.duiba.cloud.stock.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.stock.service.api.param.occupy.RollbackOccupyStockParam;

/**
 * 预占库存remote接口
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2021/12/17 5:38 下午
 * @since 0.0.1
 **/
@AdvancedFeignClient
public interface RemoteStockOccupyService {

    /**
     * 根据预占场景id和类型返还预占库存
     *
     * @param rollbackOccupyStockParam 返还预占库存请求参数
     * @return true/false
     * @throws BizException 业务异常
     *                      <ul>
     *                          <li>计量不存在</li>
     *                          <li>达到上限</li>
     *                          <li>达到下限</li>
     *                      </ul>
     */
    Boolean rollbackOccupyStock(RollbackOccupyStockParam rollbackOccupyStockParam) throws BizException;
}