package cn.com.duiba.cloud.stock.service.api.dto.channel;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * sku渠道DTO
 *
 * @author zhoujunquan
 * @TableName tb_sku_channel
 */
@Data
public class SkuChannelDTO implements Serializable {
    private static final long serialVersionUID = 8627121788640662444L;
    /**
     * sku渠道id
     *
     * @deprecated 请使用 {@link SkuChannelDTO#skuChannelId}
     */
    @Deprecated
    private Long id;

    /**
     * sku渠道id
     */
    private Long skuChannelId;

    /**
     * skuID
     */
    private Long skuId;

    /**
     * 库存id
     */
    private Long stockId;

    /**
     * 来源用户id
     */
    private Long sourceId;

    /**
     * 来源用户类型(1:平台;2:租户;3:用户)
     */
    private Integer sourceType;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 用户类型(1:平台;2:租户;3:供应商)
     */
    private Integer userType;

    /**
     * 来源名称
     */
    private String sourceName;

    /**
     * 总库存
     */
    private Long stockNumber;

    /**
     * 独占库存
     */
    private Long oneselfStockNumber;

    /**
     * 共享库存
     */
    private Long shareStockNumber;

    /**
     * 预占库存
     */
    private Long preOccupyStockNumber;

    /**
     * 可销售库存
     */
    private Long canSaleStockNumber;

    /**
     * 订单占用库存<br>
     */
    private Long orderOccupyStockNumber;

    /**
     * 成本价(自有的话就是成本价,供应商的话就是供货价)
     */
    private Long costPrice;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}